// WaitDlg.cpp : implementation file
//

#include "stdafx.h"
#include "8949G1VC.h"
#include "adt8949.h"
#include "WaitDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//int counter = 0;

//bool bshow = true;
/////////////////////////////////////////////////////////////////////////////
// WaitDlg dialog


WaitDlg::WaitDlg(CWnd* pParent /*=NULL*/)
	: CDialog(WaitDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(WaitDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_bAort=false;
	m_nResult=-100;
	m_bInit=true;
	m_bshow = true;
}


void WaitDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(WaitDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	DDX_Control(pDX, IDC_STATIC_1, m_Labl0);
	DDX_Control(pDX, IDC_STATIC_2, m_Labl1);
	DDX_Control(pDX, IDC_STATIC_3, m_Labl2);
	DDX_Control(pDX, IDC_STATIC_4, m_Labl3);
	DDX_Control(pDX, IDC_STATIC_5, m_Labl4);
	DDX_Control(pDX, IDC_STATIC_6, m_Labl5);
	DDX_Control(pDX, IDC_STATIC_7, m_Labl6);
	DDX_Control(pDX, IDC_STATIC_8, m_Labl7);
	DDX_Control(pDX, IDC_STATIC_9, m_Labl8);
	DDX_Control(pDX, IDC_STATIC_10, m_Labl9);
	DDX_Control(pDX, IDC_STATIC_11, m_Labl10);
	DDX_Control(pDX, IDC_STATIC_BK1, m_LablTime);
	
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(WaitDlg, CDialog)
	//{{AFX_MSG_MAP(WaitDlg)
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON_ABORT, OnButtonAbort)
	ON_WM_DESTROY()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// WaitDlg message handlers

DWORD WINAPI Thread1(LPVOID lpParameter)
{//̺߳
	WaitDlg *dlg=(WaitDlg*)lpParameter;
	if(dlg->m_bInit)
	{
		dlg->m_bInit = false;

		dlg->m_nResult = CCtrlCardSingletion::Instance()->InitBoard();
	}
	return 0;
}
DWORD WINAPI Thread2(LPVOID lpParameter)
{//̺߳
	WaitDlg *dlg=(WaitDlg*)lpParameter;
	long starttime1 = GetTickCount();
	while(true)
	{
		DoEvent();
		Sleep(1);
		if (dlg->m_bAort==true)//Ѽ鵽ʼ쳣ź
		{
			break;	
		}			
		
		if (dlg->m_nResult>0) 
		{//ʼ
			break;
		}			
		if (GetTickCount()-starttime1>(300000*6)) //Ϊλ
		{			
			dlg->m_nResult=-7;
			break;			
		}

	}
	return 0;
}

BOOL WaitDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_wndStatusBar = new CStatusBarCtrl;

	
	CRect rect;
	
	GetClientRect(&rect);
	
	rect.top=rect.bottom-20;
	
	m_wndStatusBar->Create(WS_CHILD|WS_VISIBLE|CCS_BOTTOM|SBARS_SIZEGRIP,rect, this, 1);

	int widths = -1;
	
	m_wndStatusBar->SetParts(1, &widths);
	
	m_wndStatusBar->SetText("Tip: if the firmware upgrade, a card takes about 3 minutes!",0,0);
	
	m_wndStatusBar->ShowWindow(SW_SHOW);

	CLabel *lbl[]={&m_Labl0,&m_Labl1, &m_Labl2, &m_Labl3, &m_Labl4, &m_Labl5,
		&m_Labl6, &m_Labl7, &m_Labl8, &m_Labl9, &m_Labl10};
	
	for (int i=0; i<11; i++)
	{
		lbl[i]->SetBkColor(RGB(220,220,220));
	}
	
	m_enterTime = CTime::GetCurrentTime();
	
	(&m_LablTime)->SetTextColor(RGB(255,250,205));
	(&m_LablTime)->SetFontSize(30);
	(&m_LablTime)->SetBkColor(RGB(0,0,0));
	(&m_LablTime)->SetText(" 00:00:00");

	SetTimer(4001,100,NULL);
	SetTimer(4000,700,NULL);
	
	CreateThread(NULL,0,Thread1,this,0 ,NULL);
	CreateThread(NULL,0,Thread2,this,0 ,NULL);



	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void WaitDlg::OnTimer(UINT_PTR nIDEvent) 
{
	int i;
	CTime curTime;
	CTimeSpan  result;
	CString strTime;
	CLabel *lbl[]={&m_Labl0,&m_Labl1, &m_Labl2, &m_Labl3, &m_Labl4, &m_Labl5,
		&m_Labl6, &m_Labl7, &m_Labl8, &m_Labl9, &m_Labl10};
	m_nCounter = m_nCounter%11;	
	
	switch(nIDEvent)
	{
	case 4001:
		if ( m_nResult!=-100 && m_bshow)
		{
			m_bshow = false;//ֻʾһ
			EndDialog(0);
			if (m_nResult<1)
			{
				m_bAort=true;//ֹʱ߳
				switch (m_nResult)
				{	
				case 0:
					MessageBox("No ADT8949G1 card installed!");
					break;
				case -1:
					MessageBox("No port driver is installed!");
					
					break;
				case -2:
					MessageBox("Control card initialization failure, PCI bridge failure!");
					
					break;
				case -3:
					MessageBox("Control card initialization failed, DSP download error!");
					
					break;
				case -4:
					MessageBox("Control card initialization failure, hardware exceptions or DLL version mismatch!");
					
					break;
				case -5:
					MessageBox("Create a mutual exclusion failure!");
					
					break;
				case -6:
					MessageBox("Open mutual exclusion!");
					
					break;
				case -7:
					MessageBox("Control card initialization failure, programmer timeout!");
					
					break;
				case -8:
					MessageBox("The dial switch is set to repeat and need to manually adjust the dial switch to point!");	
					break;
				default:
					MessageBox("Control card initialization failure, other exception reasons!");
					break;
				}
			}
			else
			{
				AfxMessageBox("Welcome, control cards can be used!");
			}

		}
		break;
	case 4000:
		for ( i=0; i<11; i++)
		{
			if (i == m_nCounter)
			{
				lbl[i]->SetBkColor(RGB(46,139,870));
			}
			else
			{
				lbl[i]->SetBkColor(RGB(220,220,220));;
			}		
		}
		
		m_nCounter++;
		
		curTime = CTime::GetCurrentTime();
		
		result = curTime - m_enterTime;
		
		strTime = result.Format( " %H:%M:%S");
		
		(&m_LablTime)->SetText(strTime);
		
		break;
	}		

	CDialog::OnTimer(nIDEvent);
}

void WaitDlg::OnClose() 
{
	//adt8949_close_card();
	ExitProcess( -1 );
	CDialog::OnClose();
}

void WaitDlg::OnButtonAbort() //жϲ
{
	m_bAort=true;
//	adt8949_close_card();
	ExitProcess( -1 );
}

void WaitDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	KillTimer(4000);
	KillTimer(4001);
	m_nCounter = 0;
	
}

int WaitDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

	return 0;
}

BOOL WaitDlg::PreTranslateMessage(MSG* pMsg) 
{
	if ( pMsg ->message ==WM_KEYDOWN)	
	{	
		
		switch (pMsg->wParam)
		{				
		case VK_RETURN:
			return TRUE;
		case VK_ESCAPE:
			return TRUE;
		default:
			break;
		}
	}	
	
	return CDialog::PreTranslateMessage(pMsg);
}
